Attribute VB_Name = "xGlobal"
Option Explicit

'/ Program Variables
'////////////////////////////////////////////////////////////

'/ Generic
Public giTwipsX    As Integer
Public giTwipsY    As Integer

'/ Toolbar97
Public giTbarButton          As Integer     '/ Holds index of toolbar button
Public ghTbarPrevWindow      As Long        '/ Handle for previous button
Public glTbarOutLeft()       As Long        '/ Position of outline, left
Public glTbarOutTop()        As Long        '/ Position of outline, top
Public glTbarOutRight()      As Long        '/ Position of outline, right
Public glTbarOutBtm()        As Long        '/ Position of outline, bottom

'/ Toolhelp
Public gbThlpActive          As Boolean     '/ Flag for active state
Public gbThlpShowNextTime    As Boolean     '/ Flag for showing help the next time
Public giThlpWait            As Integer     '/ Waiting time in milliseconds
Public glThlpBackColor       As Long        '/ Background color
Public glThlpShadowTop       As Long        '/ Top shadow color
Public glThlpShadowBtm       As Long        '/ Bottom shadow color
Public gbTbarPrevWindow      As Long        '/ Handle for previous button

'/ Window Information
'////////////////////////////////////////////////////////////

#If Win32 Then
   
   Type RECT
      Left    As Long
      Top     As Long
      Right   As Long
      Bottom  As Long
   End Type
   
   Declare Function GetWindowRect Lib "user32" (ByVal hWnd As Long, lpRect As RECT) As Long
   Declare Function GetActiveWindow Lib "user32" () As Long
   Declare Function WindowFromPoint Lib "user32" (ByVal xPoint As Long, ByVal yPoint As Long) As Long
   Declare Function ShowWindow Lib "user32" (ByVal hWnd As Long, ByVal nCmdShow As Long) As Long

#Else
   
   Type RECT
      Left    As Integer
      Top     As Integer
      Right   As Integer
      Bottom  As Integer
   End Type
   
   Declare Sub GetWindowRect Lib "User" (ByVal hWnd As Integer, lpRect As RECT)
   Declare Function GetActiveWindow Lib "User" () As Integer
   Declare Function WindowFromPoint Lib "User" (ByVal lpPointY As Integer, ByVal lpPointX As Integer) As Integer
   Declare Function ShowWindow Lib "User" (ByVal hWnd As Integer, ByVal nCmdShow As Integer) As Integer

#End If

Public Const SW_SHOWNOACTIVATE = 4

'/ Cursor Position
'////////////////////////////////////////////////////////////

#If Win32 Then
   
   Type POINTAPI
      x As Long
      y As Long
   End Type
   
   Declare Function GetCursorPos Lib "user32" (lpPoint As POINTAPI) As Long

#Else
   
   Type POINTAPI
      x As Integer
      y As Integer
   End Type
   
   Declare Sub GetCursorPos Lib "User" (lpPoint As POINTAPI)

#End If

 
Public Sub Toolhelp(frm As Form, strHelp As String)

   Dim iRtn        As Integer
   Dim Point       As POINTAPI
   
   '/ Set back color
   frm.BackColor = glThlpBackColor
   frm.lblHelp.BackColor = glThlpBackColor
   
   If Len(strHelp) Then

      '/ Make sure the help form is invisible
      frm.Hide
      
      '/ Put help string into the lblHelp
      frm.lblHelp.Caption = " " & strHelp & " "

      '/ Get cursor position and set help form
      Call GetCursorPos(Point)
      frm.Left = (Point.x - 2) * giTwipsX
      frm.Top = (Point.y + 18) * giTwipsY

      '/ Size the help form
      frm.Width = frm.lblHelp.Width + 4 * giTwipsX
      frm.Height = frm.lblHelp.Height + 5 * giTwipsY

      '/ Draw left shadow
      frm.linBorder(0).BorderColor = glThlpShadowTop
      frm.linBorder(0).X1 = 0
      frm.linBorder(0).Y1 = 0
      frm.linBorder(0).X2 = 0
      frm.linBorder(0).Y2 = frm.ScaleHeight - giTwipsY
      '/ Draw top shadow
      frm.linBorder(1).BorderColor = glThlpShadowTop
      frm.linBorder(1).X1 = 0
      frm.linBorder(1).Y1 = 0
      frm.linBorder(1).X2 = frm.ScaleWidth
      frm.linBorder(1).Y2 = 0
      '/ Draw right shadow
      frm.linBorder(2).BorderColor = glThlpShadowBtm
      frm.linBorder(2).X1 = frm.ScaleWidth - giTwipsX
      frm.linBorder(2).Y1 = giTwipsY
      frm.linBorder(2).X2 = frm.ScaleWidth - giTwipsX
      frm.linBorder(2).Y2 = frm.ScaleHeight
      '/ Draw bottom shadow
      frm.linBorder(3).BorderColor = glThlpShadowBtm
      frm.linBorder(3).X1 = 0
      frm.linBorder(3).Y1 = frm.ScaleHeight - giTwipsY
      frm.linBorder(3).X2 = frm.ScaleWidth - giTwipsX
      frm.linBorder(3).Y2 = frm.ScaleHeight - giTwipsY
      
      '/ Get help form to the top
      frm.ZOrder

      '/ Show form without the focus
      iRtn = ShowWindow(frm.hWnd, SW_SHOWNOACTIVATE)
   
   Else
      '/ Hide the help form if an empty string was passed
      frm.Hide
   End If
   
End Sub

Public Sub Toolbar97Setup(frm As Form, iNoOfIcons As Integer, Optional ctlLogo As Variant)

'/ This routines drawus the Toolbar97 on the form that has been passed
'/ to this routine and aligns the toolbar icons as well as the company
'/ logo (if a control was passed to this routine).

   Dim iCnt    As Integer
   Dim iPosX   As Integer
   Dim lRtn    As Long
   Dim iHeight As Integer
   Dim Icon97  As RECT
   
   '/ Set AutoRedraw for main form
   frm.AutoRedraw = True
      
   '/ Separate the menu line
   frm.Line (0, 0)-(frm.ScaleWidth - giTwipsX, 0), &H808080
   
   '/ Determine height and draw outline of Toolbar97
   iHeight = frm.picToolIcons(0).Height + 4
   frm.Line (0, giTwipsY)-(frm.ScaleWidth - giTwipsX, giTwipsY), &HFFFFFF
   frm.Line -(frm.ScaleWidth - giTwipsX, iHeight + (8 * giTwipsY)), &H808080
   frm.Line -(0, iHeight + (8 * giTwipsY)), &H808080
   frm.Line -(0, 0), &HFFFFFF
   
   '/ Draw the two vertical line on the left
   iPosX = 6
   For iCnt = 0 To 1
      frm.Line (iPosX * giTwipsX, 3 * giTwipsY)-(iPosX * giTwipsX, iHeight + (6 * giTwipsY)), &H808080
      frm.Line -((iPosX - 2) * giTwipsX, iHeight + (6 * giTwipsY)), &H808080
      frm.Line ((iPosX - 2) * giTwipsX, iHeight + (6 * giTwipsY))-((iPosX - 2) * giTwipsX, 3 * giTwipsY), &HFFFFFF
      frm.Line -(iPosX * giTwipsX, 3 * giTwipsY), &HFFFFFF
      iPosX = iPosX + 3
   Next
   
   '/ Position toolbar icons and draw separators
   iPosX = 14 * giTwipsX
   If iNoOfIcons Then
      For iCnt = 0 To iNoOfIcons - 1
         
         '/ Check the control tag to determine if a separator
         '/ has to be drawn before the icon
         If Left(frm.picToolIcons(iCnt).Tag, 1) = "<" Then
            frm.Line (iPosX, 2 * giTwipsY)-(iPosX, iHeight + (6 * giTwipsY)), &H808080
            frm.Line (iPosX + giTwipsX, 2 * giTwipsY)-(iPosX + giTwipsX, iHeight + (6 * giTwipsY)), &HFFFFFF
            iPosX = iPosX + 6 * giTwipsX
         End If
         
         '/ Position toolbar icon
         frm.picToolIcons(iCnt).Top = 5 * giTwipsY
         frm.picToolIcons(iCnt).Left = iPosX
         iPosX = iPosX + frm.picToolIcons(iCnt).Width + 4 * giTwipsX
         
         '/ Check the control tag to determine if a separator
         '/ has to be drawn after the icon
         If Left(frm.picToolIcons(iCnt).Tag, 1) = ">" Then
            frm.Line (iPosX, 2 * giTwipsY)-(iPosX, iHeight + (6 * giTwipsY)), &H808080
            frm.Line (iPosX + giTwipsX, 2 * giTwipsY)-(iPosX + giTwipsX, iHeight + (6 * giTwipsY)), &HFFFFFF
            iPosX = iPosX + 6 * giTwipsX
         End If
       
         '/ Get the coordinates of the toolbar icons
         #If Win32 Then
            lRtn = GetWindowRect(frm.picToolIcons(iCnt).hWnd, Icon97)
         #Else
            Call GetWindowRect(frm.picToolIcons(iCnt).hWnd, Icon97)
         #End If
   
         ReDim Preserve glTbarOutLeft(iCnt)
         ReDim Preserve glTbarOutTop(iCnt)
         ReDim Preserve glTbarOutRight(iCnt)
         ReDim Preserve glTbarOutBtm(iCnt)
         
         glTbarOutLeft(iCnt) = (Icon97.Left - 2 - 4) * giTwipsX - frm.Left
         glTbarOutTop(iCnt) = (Icon97.Top - 2 - 42) * giTwipsY - frm.Top
         glTbarOutRight(iCnt) = (Icon97.Right + 2 - 4) * giTwipsX - frm.Left
         glTbarOutBtm(iCnt) = (Icon97.Bottom + 2 - 42) * giTwipsY - frm.Top
         
       Next
   End If
   
   '/ Position the company logo, if one has been passed
   If Not IsMissing(ctlLogo) Then
      ctlLogo.Top = 4 * giTwipsY
      ctlLogo.Left = frm.ScaleWidth - ctlLogo.Width - 6 * giTwipsX
   End If

End Sub
Public Sub CenterForm(frm As Form, Optional vParent As Variant)

'/ Centers the form on the screen or on another window.
'/
'/ Pass   : frm       Form that needs to be centers
'/          vParent   Form to be centered on (optional)
'/
'/ Author            : Ron Steiner
'/ Last Modification : 6/10/96
'///////////////////////////////////////////////////////////////////////////
   
   Dim oParent    As Object
   Dim iMode      As Integer
   Dim iLeft      As Integer
   Dim iTop       As Integer
   
   If IsMissing(vParent) Then
      Set oParent = Screen
   ElseIf TypeOf vParent Is Screen Or TypeOf vParent Is Form Then
      Set oParent = vParent
   Else
      Exit Sub
   End If
   
   If TypeOf oParent Is Form Then
      iLeft = oParent.Left
      iTop = oParent.Top
   End If

   frm.Move iLeft + (oParent.Width - frm.Width) / 2, iTop + (oParent.Height - frm.Height) / 2
   
End Sub

Public Sub Toolbar97Highlight(frm As Form, bFlag As Boolean)

'/ This routine draws the button outline or removes depending on the
'/ "bFlag" variable (True/False) passed to it.

   If giTbarButton < 0 Then Exit Sub
   
   Dim ctlIcon As Object
   
   '/ Set toolbar icon as an object variable
   Set ctlIcon = frm.picToolIcons(giTbarButton)
   
   If bFlag Then
   
      '/ Draw icon highlight
      frm.Line (glTbarOutLeft(giTbarButton), glTbarOutTop(giTbarButton))-(glTbarOutLeft(giTbarButton), glTbarOutBtm(giTbarButton) - giTwipsY), &HFFFFFF
      frm.Line -(glTbarOutRight(giTbarButton) - giTwipsX, glTbarOutBtm(giTbarButton) - giTwipsY), &H808080
      frm.Line -(glTbarOutRight(giTbarButton) - giTwipsX, glTbarOutTop(giTbarButton)), &H808080
      frm.Line -(glTbarOutLeft(giTbarButton), glTbarOutTop(giTbarButton)), &HFFFFFF
      
      If gbThlpActive Then
         '/ TOOLHELP: Activate
         frm.tmrToolhelp.Enabled = True
      End If
      
   Else
      
      Dim lRtn            As Long
      Dim hTbarCurrWindow As Long
      Dim Point           As POINTAPI
      
      '/ Move icon to its original position
      frm.picToolIcons(giTbarButton).Left = glTbarOutLeft(giTbarButton) + 2 * giTwipsX
      frm.picToolIcons(giTbarButton).Top = glTbarOutTop(giTbarButton) + 2 * giTwipsY
      
      '/ Remove button outline
      frm.Line (glTbarOutLeft(giTbarButton), glTbarOutTop(giTbarButton))-(glTbarOutRight(giTbarButton) - giTwipsX, glTbarOutBtm(giTbarButton) - giTwipsY), &HC0C0C0, BF
  
      '/ Get pointer and handle to current window
      #If Win32 Then
         lRtn = GetCursorPos(Point)
         hTbarCurrWindow = WindowFromPoint(Point.x, Point.y)
      #Else
         Call GetCursorPos(Point)
         hTbarCurrWindow = WindowFromPoint(Point.y, Point.x)
      #End If
      
      Select Case hTbarCurrWindow
      Case frm.picToolIcons(giTbarButton).hWnd
                  
         '/ Draw button outline in the case you are not calling
         '/ another form
         'Call Toolbar97Highlight(frm, True)
      
      Case Else
      
         '/ Save current window as previous window, reset variable
         '/ and disable timer
         ghTbarPrevWindow = hTbarCurrWindow
         giTbarButton = -1
         
         If gbThlpActive Then
            '/ TOOLHELP: Reset
            If hTbarCurrWindow <> gbTbarPrevWindow Then
               frmHelp.Hide
               frm.tmrToolhelp.Enabled = False
               gbTbarPrevWindow = 0
               gbThlpShowNextTime = True
            End If
         End If
         
     End Select
      
   End If
   
End Sub


Public Sub Toolbar97ButtonDown(frm As Form, Index As Integer)

   If giTbarButton < 0 Then Exit Sub
   
   '/ Set icon window as the prevous window so the tool help does not
   '/ show as long as the cursor is over the same window
   ghTbarPrevWindow = frm.picToolIcons(giTbarButton).hWnd
   
   '/ Move icon one to the right and down
   frm.picToolIcons(giTbarButton).Left = glTbarOutLeft(giTbarButton) + 3 * giTwipsX
   frm.picToolIcons(giTbarButton).Top = glTbarOutTop(giTbarButton) + 3 * giTwipsY
   
   If gbThlpActive Then
      '/ TOOLHELP: Hide tool help
      Call Toolhelp(frmHelp, "")
      frm.tmrToolhelp.Enabled = False
      frm.tmrToolhelp.Interval = giThlpWait
      gbThlpShowNextTime = False
   End If
   
   DoEvents
         
   '/ Draw depressed button outline
   frm.Line (glTbarOutLeft(Index), glTbarOutTop(Index))-(glTbarOutLeft(Index), glTbarOutBtm(Index) - giTwipsY), &H808080
   frm.Line -(glTbarOutRight(Index) - giTwipsX, glTbarOutBtm(Index) - giTwipsY), &HFFFFFF
   frm.Line -(glTbarOutRight(Index) - giTwipsX, glTbarOutTop(Index)), &HFFFFFF
   frm.Line -(glTbarOutLeft(Index), glTbarOutTop(Index)), &H808080
   
End Sub
Public Sub Toolbar97MonitorCursor(frm As Form, Index As Integer)

'/ This routine monitors the cursor and performs the appropriate
'/ actions, depending over which window the pointer currently is.

   Dim lRtn            As Long
   Dim hTbarCurrWindow As Long
   Dim Point           As POINTAPI
   
   '/ Get pointer and handle to current window
   #If Win32 Then
      lRtn = GetCursorPos(Point)
      hTbarCurrWindow = WindowFromPoint(Point.x, Point.y)
   #Else
      Call GetCursorPos(Point)
      hTbarCurrWindow = WindowFromPoint(Point.y, Point.x)
   #End If
   
   '/ Determine if cursor is still over the button
   If hTbarCurrWindow <> ghTbarPrevWindow Then
      ghTbarPrevWindow = hTbarCurrWindow
      
      Select Case hTbarCurrWindow
      Case frm.picToolIcons(Index).hWnd
         
         '/ Reset previous button and remove outline
         Call Toolbar97Highlight(frm, False)
         
         '/ Save current button
         giTbarButton = Index
         
         '/ Draw outline for current button
         Call Toolbar97Highlight(frm, True)
      
      Case Else
      
         '/ Reset previous button and remove outline
         '/ if cursor is not over one of the toolbar icons
         Call Toolbar97Highlight(frm, False)
      
      End Select
      
   End If

End Sub
